<?php
	header('Access-Control-Allow-Origin: *');
	header('Content-type: application/json');
	require_once 'include/class.user.php';
	$user_home = new USER();

	if (!empty($_GET["action"])) {
		$action = $_GET["action"];
		switch ($action) {
			case 'getScores':
				if (!empty($_GET["leaderboardId"])) {
					$leaderboardId = $_GET["leaderboardId"];
				}
				if (!empty($_GET["lang"])) {
					$lang = $_GET["lang"];
				}
				
				if (empty($leaderboardId) || empty($lang)) {
                    $return["status"] = "error";
					$return["data"] = "Missing Parameter";
					echo json_encode($return);
					return;
				} else {
					$leaderboardScores = [];
					$leaderboardScores["scores"] = [];
					$sql1 = "SELECT token, name, reverse FROM leaderboards WHERE id = ?";
					if ($stmt = $user_home->prepareQuery($sql1)) {
						$stmt->bind_param('i', $leaderboardId);
						$stmt->execute();

						$stmt->store_result();
						$stmt->bind_result($leaderboardToken, $leaderboardName, $leaderboardReverse);
						$stmt->fetch();

						if ($stmt->num_rows == 1) {
							$leaderboardScores["name"] = $leaderboardName;
							$leaderboardScores["id"] = $leaderboardId;
						} else {
							$return["status"] = "error";
							switch ($lang) {
								case "en":
									$return["data"] = "The leaderboard with this id does not exist";
									break;
								case "fa":
									$return["data"] = "جدول امتیازی با شناسه موردنظر وجود ندارد";
									break;
							}
							echo json_encode($return);
							return;
						}
						$stmt->free_result();
						switch($leaderboardReverse) {
							case 1:
								$reverse = 'ASC';
								break;
							case 0:
								$reverse = 'DESC';
								break;
						}
					}
					
					$sql2 = "SELECT score, user_id, name, add_datetime FROM {$leaderboardToken}_scores WHERE table_id=? ORDER BY score $reverse";
					if ($stmt = $user_home->prepareQuery($sql2)) {
						$stmt->bind_param('i', $leaderboardId);
						$stmt->execute();
						$stmt->bind_result($score, $userID, $name, $date);
						while ($stmt->fetch()) {
							$leaderboardScores["scores"][] = array("score" => $score, "userID" => $userID, "name" => $name, "date" => $date);
						}
					}
				
					$leaderboardScore = [];
					foreach ($leaderboardScores["scores"] as $score) {
						$leaderboardScore[] = array(
							"userId" => $score["userID"],
							"name" => $score["name"],
							"score" => $score["score"],
							"date" => $score["date"]
						);
					}
					echo json_encode(array(
						"status" => "success",
						"leaderboardName" => $leaderboardScores["name"],
						"data" => array_values($leaderboardScore)
					));
				}
				break;
			case 'getRank':
				if (!empty($_GET["leaderboardId"])) {
					$leaderboardId = $_GET["leaderboardId"];
				}
				if (!empty($_GET["userId"])) {
					$userId = $_GET["userId"];
				}
				if (!empty($_GET["lang"])) {
					$lang = $_GET["lang"];
				}
				
				if (empty($leaderboardId) || empty($userId) || empty($lang)) {
                    $return["status"] = "error";
					$return["data"] = "Missing Parameter";
					echo json_encode($return);
					return;
				} else {
					if ($stmt = $user_home->prepareQuery("SELECT token, reverse, name FROM leaderboards WHERE id = ?")) {
						$stmt->bind_param('i', $leaderboardId);
						$stmt->execute();

						$stmt->store_result();
						$stmt->bind_result($leaderboardToken, $leaderboardReverse, $leaderboardName);
						$stmt->fetch();
						
						if ($stmt->num_rows == 1) {
						   
						} else {
							$return["status"] = "error";
							switch ($lang) {
								case "en":
									$return["data"] = "The leaderboard with this id does not exist";
									break;
								case "fa":
									$return["data"] = "جدول امتیازی با شناسه موردنظر وجود ندارد";
									break;
							}
							echo json_encode($return);
							return;
						}
					}
					
					switch($leaderboardReverse) {
						case 1:	
							$sql = "SELECT 1 + (SELECT count( * ) FROM `{$leaderboardToken}_scores` a WHERE a.score < b.score ) AS rank FROM `{$leaderboardToken}_scores` b WHERE user_id=? AND table_id=? ORDER BY rank LIMIT 1";
							break;
						case 0:
							$sql = "SELECT 1 + (SELECT count( * ) FROM `{$leaderboardToken}_scores` a WHERE a.score > b.score ) AS rank FROM `{$leaderboardToken}_scores` b WHERE user_id=? AND table_id=? ORDER BY rank LIMIT 1";
							break;
					}
					
					if ($stmt = $user_home->prepareQuery($sql)) {
						$stmt->bind_param('si', $userId, $leaderboardId);

						$stmt->execute();
						$stmt->store_result();
						$stmt->bind_result($rank);
						$stmt->fetch();
						
						if ($stmt->num_rows > 0) {
							$return["status"] = "success";
							$return["rank"] = $rank;
							echo json_encode($return);
						} else {
							$return["status"] = "norank";
							switch ($lang) {
								case "en":
									$return["data"] = "User with this id does not exist.";
									break;
								case "fa":
									$return["data"] = "کاربری با این شناسه وجود ندارد.";
									break;
							}
							echo json_encode($return);
						}
					} else {
						$return["status"] = "error";
						switch ($lang) {
							case "en":
								$return["data"] = "An error occurred while receiving user rank.";
								break;
							case "fa":
								$return["data"] = "خطایی در دریافت رتبه کاربر رخ داده است.";
								break;
						}
						echo json_encode($return);
					}
				}
				break;
			case 'getHits':
				if (!empty($_GET["achievementId"])) {
					$achievementId = $_GET["achievementId"];
				}
				if (!empty($_GET["lang"])) {
					$lang = $_GET["lang"];
				}
				
				if (empty($achievementId) || empty($lang)) {
                    $return["status"] = "error";
					$return["data"] = "Missing Parameter";
					echo json_encode($return);
					return;
				} else {
					$achievementHits = [];
					$achievementHits["hits"] = [];
					$sql1 = "SELECT token, name FROM achievements WHERE id = ?";
					if ($stmt = $user_home->prepareQuery($sql1)) {
						$stmt->bind_param('i', $achievementId);
						$stmt->execute();

						$stmt->store_result();
						$stmt->bind_result($achievementToken, $achievementName);
						$stmt->fetch();

						if ($stmt->num_rows == 1) {
							$achievementHits["name"] = $achievementName;
							$achievementHits["id"] = $achievementId;
						} else {
							$return["status"] = "error";
							switch ($lang) {
								case "en":
									$return["data"] = "The achievement with this id does not exist";
									break;
								case "fa":
									$return["data"] = "دستاوردی با شناسه موردنظر وجود ندارد";
									break;
							}
							echo json_encode($return);
							return;
						}
						$stmt->free_result();
					}
					
					$sql2 = "SELECT user_id, add_datetime FROM {$achievementToken}_hits WHERE achievement_id=? ORDER BY add_datetime DESC";
					if ($stmt = $user_home->prepareQuery($sql2)) {
						$stmt->bind_param('i', $achievementId);
						$stmt->execute();
						$stmt->bind_result($userID, $date);
						while ($stmt->fetch()) {
							$achievementHits["hits"][] = array("userID" => $userID, "date" => $date);
						}
					}
				
					$achievementHit = [];
					foreach ($achievementHits["hits"] as $hit) {
						$achievementHit[] = array(
							"userId" => $hit["userID"],
							"date" => $hit["date"]
						);
					}
					echo json_encode(array(
						"status" => "success",
						"achievementName" => $achievementHits["name"],
						"data" => array_values($achievementHit)
					));
				}
				break;
			case 'checkHit':
				if (!empty($_GET["achievementId"])) {
					$achievementId = $_GET["achievementId"];
				}
				if (!empty($_GET["userId"])) {
					$userId = $_GET["userId"];
				}
				if (!empty($_GET["lang"])) {
					$lang = $_GET["lang"];
				}
				
				if (empty($achievementId) || empty($userId) || empty($lang)) {
                    $return["status"] = "error";
					$return["data"] = "Missing Parameter";
					echo json_encode($return);
					return;
				} else {
					if ($stmt = $user_home->prepareQuery("SELECT token, name FROM achievements WHERE id = ?")) {
						$stmt->bind_param('i', $achievementId);
						$stmt->execute();

						$stmt->store_result();
						$stmt->bind_result($achievementToken, $achievementName);
						$stmt->fetch();
						
						if ($stmt->num_rows == 1) {
						   
						} else {
							$return["status"] = "error";
							switch ($lang) {
								case "en":
									$return["data"] = "The achievement with this id does not exist";
									break;
								case "fa":
									$return["data"] = "دستاوردی با شناسه موردنظر وجود ندارد";
									break;
							}
							echo json_encode($return);
							return;
						}
					}
					
					$sql = "SELECT user_id FROM {$achievementToken}_hits WHERE user_id=? AND achievement_id=?";
					
					if ($stmt = $user_home->prepareQuery($sql)) {
						$stmt->bind_param('si', $userId, $achievementId);

						$stmt->execute();
						$stmt->store_result();
						$stmt->bind_result($uID);
						$stmt->fetch();
						
						if ($stmt->num_rows > 0) {
							$return["status"] = "success";
							$return["data"] = true;
							echo json_encode($return);
						} else {
							$return["status"] = "nohit";
							switch ($lang) {
								case "en":
									$return["data"] = "User with this id does not exist.";
									break;
								case "fa":
									$return["data"] = "کاربری با این شناسه وجود ندارد.";
									break;
							}
							echo json_encode($return);
						}
					} else {
						$return["status"] = "error";
						switch ($lang) {
							case "en":
								$return["data"] = "An error occurred while receiving user hit.";
								break;
							case "fa":
								$return["data"] = "خطایی در دریافت دستیابی کاربر رخ داده است.";
								break;
						}
						echo json_encode($return);
					}
				}
				break;
			case 'getVersion':
				if (!empty($_GET["id"])) {
					$id = $_GET["id"];
				}
				if (!empty($_GET["lang"])) {
					$lang = $_GET["lang"];
				}
				
				if (empty($id) || empty($lang)) {
                    $return["status"] = "error";
					$return["data"] = "Missing Parameter";
					echo json_encode($return);
					return;
				} else {
					if ($stmt = $user_home->prepareQuery("SELECT title, version, is_force, update_link, message, changes FROM versions WHERE id = ?")) {
						$stmt->bind_param('i', $id);
						$stmt->execute();

						$stmt->store_result();
						$stmt->bind_result($versionTitle, $versionVersion, $versionForce, $updateLink, $versionMessage, $versionChanges);
						$stmt->fetch();
						
						if ($stmt->num_rows > 0) {
							$return["status"] = "success";
							$return["title"] = $versionTitle;
							$return["version"] = $versionVersion;
							$force = (($versionForce == 1) ? true : false);
							$return["force"] = $force;
							$return["update_link"] = $updateLink;
							$return["message"] = $versionMessage;
							$return["changes"] = $versionChanges;
							echo json_encode($return);
						} else {
							$return["status"] = "error";
							switch ($lang) {
								case "en":
									$return["data"] = "The version with this id does not exist";
									break;
								case "fa":
									$return["data"] = "نسخه ای با این شناسه وجود ندارد";
									break;
							}
							echo json_encode($return);
							return;
						}
					} else {
						$return["status"] = "error";
						switch ($lang) {
							case "en":
								$return["data"] = "An error occurred while receiving version.";
								break;
							case "fa":
								$return["data"] = "خطایی در دریافت نسخه رخ داده است.";
								break;
						}
						echo json_encode($return);
					}
				}
				break;
		}
	}
	
	function record_exists ($table, $column1, $value1, $column2, $value2) {
		$user_home = new USER();
		$stmt = $user_home->prepareQuery("SELECT * FROM $table WHERE $column1=? AND $column2=?");
		$stmt->bind_param('si', $value1, $value2);
		$stmt->execute();
		$stmt->store_result();
		$stmt->fetch();
		if ($stmt->num_rows > 0) {
			return true;
		} else {
			return false;
		}
	}
?>